using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace testDllApp
{
   public partial class Form1 : Form
   {
      /// <summary>
      /// 
      /// </summary>
      public Form1()
      {
         InitializeComponent();
      }

      [DllImport("TaurusInterface.dll", EntryPoint = "verificarConexion")]
      private static extern bool verificarConexion(String puertoConexion);

      [DllImport("TaurusInterface.dll", EntryPoint = "LeerLibroMensual")]
      private static extern bool LeerLibroMensual(String FechaDesde, String FechaHasta, String NombreArchivoSalida, String Extension);

      [DllImport("TaurusInterface.dll", EntryPoint = "LeerLibroDiario")]
      private static extern bool LeerLibroDiario(String Fecha, String NombreArchivoSalida, String Extension);

      [DllImport("TaurusInterface.dll", EntryPoint = "GenerarLibroMensual")]
      private static extern bool GenerarLibroMensual(String Directorio, String NombreArchivoSalida, String Extension);

      private void btnLibroMensual_Click(object sender, EventArgs e)
      {
         string fileName = null;
         string fileExt = null;

         if (UseExt.Checked)
           fileExt = txtExtension.Text;

         if (UseFile.Checked)
           fileName = txtFileName.Text;

         if (UseDownload.Checked)
         {
           if (!verificarConexion(txtPortNum.Value.ToString()))
           {
             MessageBox.Show("Falla en la conexin");
             return;
           }

           if (LeerLibroMensual(dateFrom.Text, dateTo.Text, fileName, fileExt))
             MessageBox.Show("Libro mensual ledo correctamente");
           else
             MessageBox.Show("Falla al leer libro mensual");
         }
         else
         {
           if (GenerarLibroMensual(txtFolder.Text, fileName, fileExt))
             MessageBox.Show("Libro mensual generado correctamente");
           else
             MessageBox.Show("Falla al generar libro mensual");
         }
      }

      private void btnLibroDiario_Click(object sender, EventArgs e)
      {
         if (!verificarConexion(txtPortNum.Value.ToString()))
         {
            MessageBox.Show("Falla en la conexin");
            return;
         }

         string fileName = null;
         string fileExt = null;

         if (UseExt.Checked)
           fileExt = txtExtension.Text;

         if (UseFile.Checked)
           fileName = txtFileName.Text;

         if (UseZ.Checked)
         {
           if (LeerLibroDiario(txtZReport.Value.ToString(), fileName, fileExt))
             MessageBox.Show("Libro diario ledo correctamente");
           else
             MessageBox.Show("Falla al leer libro diario");
         }
         else
         {
           if (LeerLibroDiario(dateDiario.Text, fileName, fileExt))
             MessageBox.Show("Libro diario ledo correctamente");
           else
             MessageBox.Show("Falla al leer libro diario");
         }

      }

      private void UseFile_CheckedChanged(object sender, EventArgs e)
      {
        txtFileName.Enabled = UseFile.Checked;
        btnBrowseFile.Enabled = UseFile.Checked;
        txtExtension.Enabled = UseExt.Checked;
      }

      private void btnBrowseFile_Click(object sender, EventArgs e)
      {
        if ( openFile.ShowDialog() == DialogResult.OK )
          txtFileName.Text = openFile.FileName;
      }

      private void btnFolderBrowser_Click(object sender, EventArgs e)
      {
        if (folderBrowser.ShowDialog() == DialogResult.OK)
          txtFolder.Text = folderBrowser.SelectedPath;
      }

      private void UseDownload_CheckedChanged(object sender, EventArgs e)
      {
        txtFolder.Enabled = UseCreate.Checked;
        btnFolderBrowser.Enabled = UseCreate.Checked;
        dateFrom.Enabled = UseDownload.Checked;
        dateTo.Enabled = UseDownload.Checked;

        if (UseCreate.Checked)
          btnLibroMensual.Text = "Generar";
        else
          btnLibroMensual.Text = "Descargar";
      }

      private void UseZ_CheckedChanged(object sender, EventArgs e)
      {
        txtZReport.Enabled = UseZ.Checked;
        dateDiario.Enabled = UseDate.Checked;
      }
   }
}